/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.entity.EntityNPCInterface;

public class ChunkController
implements ForgeChunkManager.LoadingCallback {
    public static ChunkController instance;
    private final HashMap<Entity, ForgeChunkManager.Ticket> tickets = new HashMap();

    public ChunkController() {
        instance = this;
    }

    public void clear() {
        this.tickets.clear();
    }

    public void deleteNPC(EntityNPCInterface npc) {
        ForgeChunkManager.Ticket ticket = this.tickets.get((Object)npc);
        if (ticket != null) {
            this.tickets.remove((Object)npc);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public ForgeChunkManager.Ticket getTicket(EntityNPCInterface npc) {
        ForgeChunkManager.Ticket ticket = this.tickets.get((Object)npc);
        if (ticket != null) {
            return ticket;
        }
        if (this.size() >= CustomNpcs.ChuckLoaders) {
            return null;
        }
        ticket = ForgeChunkManager.requestTicket((Object)CustomNpcs.instance, (World)npc.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (ticket == null) {
            return null;
        }
        ticket.bindEntity((Entity)npc);
        ticket.setChunkListDepth(6);
        this.tickets.put((Entity)npc, ticket);
        return null;
    }

    public int size() {
        return this.tickets.size();
    }

    public boolean hasToNpc(EntityNPCInterface npc) {
        return this.tickets.containsKey((Object)npc);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        CustomNpcs.debugData.start(null);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (!(ticket.getEntity() instanceof EntityNPCInterface)) continue;
            EntityNPCInterface npc = (EntityNPCInterface)ticket.getEntity();
            if (npc.advanced.jobInterface.getEnumType() != JobType.CHUNK_LOADER) continue;
            this.tickets.put((Entity)npc, ticket);
            int x = MathHelper.func_76128_c((double)npc.field_70165_t);
            int z = MathHelper.func_76128_c((double)npc.field_70161_v);
            for (int u = -1; u < 2; ++u) {
                for (int v = -1; v < 2; ++v) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x + u, z + v));
                }
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void unload(int toRemove) {
        Iterator<Entity> ite = this.tickets.keySet().iterator();
        int i = 0;
        while (ite.hasNext()) {
            if (i >= toRemove) {
                return;
            }
            Entity entity = ite.next();
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.tickets.get(entity));
            ite.remove();
            ++i;
        }
    }
}

